package gov.va.med.mhv.common.data.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;

@Entity
@Table(name = "IPA")
public class InPersonAuthenticationLight extends AbstractBaseEntity {

	private static final long serialVersionUID = -3833108733685880260L;

	@Id
	@Column(name = "IPA_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "FORM_SIGNED", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean participationFormSigned;

	@Column(name = "DEFER_REASON")
	private String defermentReason;

	@Column(name = "REMOVAL_REASON")
	private String removalReason;

	@Column(name = "AUTH_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date authenticationDate;

	@Column(name = "ID_PRESENT", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean identificationPresented;

	@Column(name = "VIDEO_VIEWED", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean videoViewed;

	@Column(name = "STATUS")
	private String status;

	@Column(name = "ACCESS_APPROVED", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean approvedForRecordsAccess;

	@Column(name = "PATIENT_PATIENT_ID", insertable = true, updatable = true)
	private Long patientId;

	@Column(name = "FACILITY_INFO_FACILITY_INFO_ID", insertable = false, updatable = false)
	private Long authenticatingFacilityId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "FACILITY_INFO_FACILITY_INFO_ID")
	private FacilityInfo authenticatingFacility;

	@Column(name = "AUTHENTICATED_BY")
	private String authenticatedBy;

	@Column(name = "MVI_AUTHENTICATION_STATUS")
	private String mviAuthenticationStatus;

	@Column(name = "START_UPG_ONLINE_DT")
	@Temporal(TemporalType.TIMESTAMP)
	private Date startUpgradeOnlineDateTime;

	@Column(name = "START_UPG_MAN_DT")
	@Temporal(TemporalType.TIMESTAMP)
	private Date startUpgradeManualDateTime;

	@Column(name = "SIGNED_FORM_ONLINE_DT")
	@Temporal(TemporalType.TIMESTAMP)
	private Date signedFormOnlineDateTime;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Boolean getParticipationFormSigned() {
		return participationFormSigned;
	}

	public void setParticipationFormSigned(Boolean participationFormSigned) {
		this.participationFormSigned = participationFormSigned;
	}

	public String getDefermentReason() {
		return defermentReason;
	}

	public void setDefermentReason(String defermentReason) {
		this.defermentReason = defermentReason;
	}

	public String getRemovalReason() {
		return removalReason;
	}

	public void setRemovalReason(String removalReason) {
		this.removalReason = removalReason;
	}

	public Date getAuthenticationDate() {
		return authenticationDate;
	}

	public void setAuthenticationDate(Date authenticationDate) {
		this.authenticationDate = authenticationDate;
	}

	public Boolean getIdentificationPresented() {
		return identificationPresented;
	}

	public void setIdentificationPresented(Boolean identificationPresented) {
		this.identificationPresented = identificationPresented;
	}

	public Boolean getVideoViewed() {
		return videoViewed;
	}

	public void setVideoViewed(Boolean videoViewed) {
		this.videoViewed = videoViewed;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Boolean getApprovedForRecordsAccess() {
		return approvedForRecordsAccess;
	}

	public void setApprovedForRecordsAccess(Boolean approvedForRecordsAccess) {
		this.approvedForRecordsAccess = approvedForRecordsAccess;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public Long getAuthenticatingFacilityId() {
		return authenticatingFacilityId;
	}

	public void setAuthenticatingFacilityId(Long authenticatingFacilityId) {
		this.authenticatingFacilityId = authenticatingFacilityId;
	}

	public FacilityInfo getAuthenticatingFacility() {
		return authenticatingFacility;
	}

	public void setAuthenticatingFacility(FacilityInfo authenticatingFacility) {
		this.authenticatingFacility = authenticatingFacility;
	}

	public String getAuthenticatedBy() {
		return authenticatedBy;
	}

	public void setAuthenticatedBy(String authenticatedBy) {
		this.authenticatedBy = authenticatedBy;
	}

	public String getMviAuthenticationStatus() {
		return mviAuthenticationStatus;
	}

	public void setMviAuthenticationStatus(String mviAuthenticationStatus) {
		this.mviAuthenticationStatus = mviAuthenticationStatus;
	}

	public Date getStartUpgradeOnlineDateTime() {
		return startUpgradeOnlineDateTime;
	}

	public void setStartUpgradeOnlineDateTime(Date startUpgradeOnlineDateTime) {
		this.startUpgradeOnlineDateTime = startUpgradeOnlineDateTime;
	}

	public Date getStartUpgradeManualDateTime() {
		return startUpgradeManualDateTime;
	}

	public void setStartUpgradeManualDateTime(Date startUpgradeManualDateTime) {
		this.startUpgradeManualDateTime = startUpgradeManualDateTime;
	}

	public Date getSignedFormOnlineDateTime() {
		return signedFormOnlineDateTime;
	}

	public void setSignedFormOnlineDateTime(Date signedFormOnlineDateTime) {
		this.signedFormOnlineDateTime = signedFormOnlineDateTime;
	}

}
